﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.Collections.ObjectModel;
using System.Text;
using System.ComponentModel;

namespace ImageRotatorExtender
{
    /// <summary>
    /// Summary description for ExtenderControl1
    /// </summary>
    [
        TargetControlType(typeof(Image))
    ]
    public class ImageRotator : ExtenderControl
    {
        public ImageRotator()
        {
        }

        int _rotationInterval = 0;
        [DefaultValue(3), DisplayName("RotationInterval(seconds))")]
        public int RotationInterval 
        { 
            get
            {
                if (_rotationInterval == 0)
                {
                    // ustawia wartość domyślną
                    _rotationInterval = 3;
                    return _rotationInterval;
                }
                else
                {
                    return _rotationInterval;
                }
            }
            set 
            {
                _rotationInterval = value;
            } 
        }

        public string ImageList { get; set; }

        private string CreateImageListArray()
        {
            string[] imageList = ImageList.Split(',');
            if (imageList.Length == 0)
                return "";

            StringBuilder arrayList = new StringBuilder();
            bool first = true;
            arrayList.Append("new Array(");
            foreach (string value in imageList)
            {
                if (first)
                {
                    first = false;
                }
                else
                {
                    arrayList.Append(",");
                }
                arrayList.Append("'");
                arrayList.Append(value);
                arrayList.Append("'");
            }
            arrayList.Append(")");
            return arrayList.ToString();

        }
        protected override IEnumerable<ScriptDescriptor>
                GetScriptDescriptors(System.Web.UI.Control targetControl)
        {
            ScriptBehaviorDescriptor descriptor = new ScriptBehaviorDescriptor(
                "ImageRotatorExtender.ImageRotator", targetControl.ClientID);
            descriptor.AddProperty("rotationInterval", RotationInterval);
            if (!string.IsNullOrEmpty(ImageList))
            {
                descriptor.AddProperty("imageList",ImageList.Split(','));
                
                // Wywołanie umieszczone w komentarzu demonstruje, jak przekazać wartość do właściwości skryptu
                // i wymusić jej przetworzenie w momencie przypisywania. Aby sprawdzić działanie tego rozwiązania
                // umieść powyższe wywołanie w komentarzu i usuń sekwencję // sprzed poniższego wywołania.
                
                //descriptor.AddScriptProperty("imageList", CreateImageListArray());
            }
            yield return descriptor;
        }

        // generuje referencję do skryptu
        protected override IEnumerable<ScriptReference>
                GetScriptReferences()
        {
            yield return new ScriptReference(
                "ImageRotatorExtender.ImageRotator.js", 
                this.GetType().Assembly.FullName);
        }
    }
}